# Vespucci 17.0 Highlights

2022-01-28
  
### Improved key handling and new OAuth 1.0a keys

This release consolidates nearly all key handling and provides a 
facility to load your own keys from a file, be it for additional OSM API instances or 
to add api keys for imagery providers.

As a further change we have added new client keys for Vespucci that are different from 
the ones distributed with the source code. This means you will have to re-authorize 
the app either on the first upload or manually via the function in the _Tools_ menu 
(spanner button) if you are using our official release and not a build from a third 
party or yourself. The new authorisation entry in your OpenStreetMap account will identify 
as _Vespucci 2022_

### Improved relation handling when splitting ways

This release adds further functionality to the relation handling when splitting ways. 
Prior releases did this correctly when at least one neighbouring relation member was 
present and the relation was ordered, but did not warn if this prerequisite was not 
fulfilled.

Now you will get a choice of downloading missing relation members before splitting a 
way and, if that was not possible, a warning indicating which relations were potentially 
affected by the splitting.
  
### Support for deprecated tags, roles and values in presets

Support for indicating deprecated tags, roles and list_entry values in presets has been 
added. Just as with complete preset items if the _deprecated_ attribute is set they 
will not be actively offered as a choce, but will be visible and using for matching 
if already present.
  
### Usability improvements property editor

As a first step in improving the property editor that will continue over the next couple 
of releases we have:

- improved the performance and memory use of the members tab for relations. Displaying 
  and editing multiple 1000s of members should be no problem now. Note however that 
  at roughly 20'000 members the fixed size Android internal rpc buffer will be too small 
  and editing the relation will fail. One of the planned future changes is to rework 
  how parameters are passed to the property editor to avoid this limitation.
- The header line in the _Details_, _Members_ and _Relations_ tabs is now fixed and 
  will not scroll with the contents.
- In the _Details_ tab the width of the dropdown for the values has been increased.
- The most recently used values will only be added for longer lists for which having 
  them at the top is actually useful. If MRU values are added, a thin ruler will indicate 
  where the regular values start.

### Way creation and appending modes changes

Due to an oversight it was possible to drag a way while adding nodes to it. As this 
cannot be handled conistently in the current undo framework it has been disabled for 
now. For more infomation see [multi-level undo](https://github.com/MarcusWolschon/osmeditor4android/issues/1493).

Often it would be easier to create new ways without newly added nodes snapping to exist 
nodes or ways. This release adds a toggle in the mode that will change the behaviour 
on the fly.

Note: if you are creating a closed way you will need to either enable the snapping mode 
or merge the last node manually.
  
### Way intersection function

If two intersecting ways are selected in Multi-Select mode you can now add a new node 
at the intersection. If there are multiple intersections only one will be created per 
operation.

### Additional valdiations and upload dialog changes

This release adds detection of untagged orphan nodes, missing required relation member 
roles (for example missing _outer_ and _inner_ rols on multi polygon members), and relation 
loops. As detecting these condiditions can be quite expensive they are only run when you 
decide to upload. Highlighting of the issues will remain if you exit the upload dialog, 
but will vanish if you then edit the object. 

To make the review of objects pre-upload easier they are now sorted at the top of the 
upload dialog. 

### Updated voice input support (experimental)

The support of voice input has been simplified and moved to an editing mode.

To activate:

- enable voice commands in the _Advanced preferences_, section _Experimental_
- switch the editing mode to _Voice_ by long pressing the lock icon and selecting _Voice_

In the _Voice_ mode the "+" button offers two possible actions:

- _Add tagged node_ this will and a node with tags at a the selected location, possible 
voice input is _thing_ or _thing name_. Examples: saying _McDonalds's_ will add a McDonald's 
at the location, saying _butcher_ will add a butcher and saying _butcher Miller_ will 
add add a butcher with the name tag set to _Miller_. To facilitate debugging, a source:original_text 
tag will be added.
- _Add map note_ this will add a map note at the location with the recognized text.

The previous existing support for adding addresses via voice input of the house number 
is currently not supported.

The purpose of this functionality is to explore how future support of alternative input 
source should work, ideas and feedback is welcome.  

## Miscellaneous

- Add refactor GPX and OSC exports to use a normal file selector
- Add support for task autoprune
- Add allow editing custom imagery configuration from layer entry
- Add support adding a custom layer from the layer dialog
- Add simplified and improved orthogonalization
- Add use location to validate elements for missing keys
- Add compute pseudo accuracy from NMEA
- Add ElementHistoryDialog from 2021 GSOC project
- Fix MapRoulette key management

# Upgrading from previous versions

* As the saved state file has changed you should upload any pending changes before updating.

# Known problems

* The documentation is out of date.
* For other known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)
